﻿// jishi.js
// -*- coding: utf-8 -*-
// 情话列表
const loveWords = [
    "你是我疲惫生活中的温柔梦想",
    "星河滚烫，你是人间理想",
    "山水一程，三生有幸",
    "世界很大，我的心很小，只装得下你",
    "遇见你，是所有美好故事的开始",
    "我想和你一起，虚度光阴，直到永远",
    "你的名字，是我见过最短的情诗",
    "春风十里，不如你",
    "往后余生，风雪是你，平淡是你",
    "你朝我走来的路途，温柔了万般光景"
];

// 获取DOM元素
const timerEl = document.getElementById('timer');
const loveTextEl = document.getElementById('loveText');

// 计时变量
let seconds = 0;
let timerInterval;
let popupInterval;
let isTextShowing = false; // 标记情话是否显示

// 格式化时间：HH:MM:SS
function formatTime(seconds) {
    const hours = Math.floor(seconds / 3600).toString().padStart(2, '0');
    const minutes = Math.floor((seconds % 3600) / 60).toString().padStart(2, '0');
    const secs = (seconds % 60).toString().padStart(2, '0');
    return `${hours}:${minutes}:${secs}`;
}

// 更新计时器
function updateTimer() {
    seconds++;
    timerEl.textContent = formatTime(seconds);
}

// 随机获取一句情话
function getRandomLoveWord() {
    const randomIndex = Math.floor(Math.random() * loveWords.length);
    return loveWords[randomIndex];
}

// 显示情话文字
function showLoveText() {
    if (isTextShowing) return;
    isTextShowing = true;
    loveTextEl.textContent = getRandomLoveWord();
    loveTextEl.classList.add('active');

    // 5秒后自动隐藏情话（修改此处的5000即为5秒）
    setTimeout(() => {
        loveTextEl.classList.remove('active');
        setTimeout(() => {
            isTextShowing = false;
        }, 300); // 等待过渡动画结束（300毫秒与CSS过渡时间一致）
    }, 5000);
}

// 初始化
function init() {
    // 启动计时器
    timerInterval = setInterval(updateTimer, 1000);

    // 每10秒弹出一次情话（可自行修改间隔，比如改为15000即15秒）
    popupInterval = setInterval(showLoveText, 10000);

    // 首次加载立即弹出（可选，取消注释即可）
    // showLoveText();

    // 防止文字被选中
    loveTextEl.addEventListener('selectstart', (e) => e.preventDefault());
}

// 页面加载完成后初始化
window.addEventListener('DOMContentLoaded', init);

// 页面离开时清除定时器
window.addEventListener('beforeunload', () => {
    clearInterval(timerInterval);
    clearInterval(popupInterval);
});