﻿// 等待DOM加载完成后执行
document.addEventListener('DOMContentLoaded', function() {
    // 获取按钮元素
    const backToTopBtn = document.getElementById('backToTop');

    // 监听滚动事件：滚动超过300px显示按钮
    window.addEventListener('scroll', () => {
        if (window.scrollY > 300) {
            backToTopBtn.classList.add('show');
        } else {
            backToTopBtn.classList.remove('show');
        }
    });

    // 点击按钮：平滑滚动返回顶部
    backToTopBtn.addEventListener('click', () => {
        window.scrollTo({
            top: 0,
            behavior: 'smooth'
        });
    });

    // 兼容：为不支持smooth滚动的浏览器提供降级方案
    if (!('scrollBehavior' in document.documentElement.style)) {
        backToTopBtn.addEventListener('click', () => {
            let top = window.scrollY;
            const timer = setInterval(() => {
                top -= 50;
                if (top <= 0) {
                    clearInterval(timer);
                    top = 0;
                }
                window.scrollTo(0, top);
            }, 16);
        });
    }
});